#!/bin/bash

# Script to package the MarketingBot extension
# Run this to create a ZIP file you can upload to your Admin Panel

echo "📦 Packaging MarketingBot Extension..."

# Check if directory exists
if [ -d "app/Extensions/MarketingBot" ]; then
    cd app/Extensions
    
    # Remove old zip if exists
    rm -f marketing-bot.zip
    
    # Create new zip
    zip -r marketing-bot.zip MarketingBot -x "*.DS_Store"
    
    echo ""
    echo "✅ Success! Created: app/Extensions/marketing-bot.zip"
    echo "📂 You can now upload this file to your Admin Panel!"
else
    echo "❌ Error: MarketingBot directory not found!"
    echo "Make sure you are in the project root folder."
fi
